struct VS_INPUT // FVF 322
{
    float4 Position   : POSITION;
	float4 Diffuse	  : COLOR;
    float2 TexCoord   : TEXCOORD0;
};

struct VS_OUTPUT
{
    float4 Position 	: POSITION;
    float2 TexCoord		: TEXCOORD0;
	float4 Diffuse		: TEXCOORD1;
	float4 WorldPos		: TEXCOORD3;
	float4 VertPVDepth  : TEXCOORD4;
};

sampler2D Tex0 : register( s0 );

samplerCUBE TexEnv : register( s4 );

float4x4 World : WORLD;
float4x4 View : VIEW;
float4x4 ViewProj : VIEWPROJ;

#define WorldSpaceLight
#include "Light.fx"
#include "Fog.fx"

VS_OUTPUT vs_main(in VS_INPUT In)
{
    VS_OUTPUT Out;
	float4 posWorld = mul(In.Position, World);
    Out.Position = mul(posWorld, ViewProj); // position in clip space
	Out.WorldPos = posWorld; // position in world space
	Out.VertPVDepth.xyz = In.Position.xyz; // vertex position
	Out.VertPVDepth.w = mul(posWorld, View).z; // depth of position in view space
	Out.TexCoord = In.TexCoord;
	Out.Diffuse = In.Diffuse;
	return Out;
}

float randomn(float4 seed)
{
	float dot_product = dot(seed, float4(12.9898,78.233,45.164,94.673));
    return frac(sin(dot_product) * 43758.5453);
}
/*
float4x4 ViewProjLight;
sampler2D TexShadow : register( s15 );

float4 calcShadowPos(float4 WorldPos, float2 ShadowTexC, float4 vPosLight)
{
	ShadowTexC.y = 1.0 - ShadowTexC.y;
	return float4(ShadowTexC.xy, vPosLight.z/vPosLight.w, 0.0);
}

float calcLightAmount(float4 WorldPos)
{
	const float Half = 0.5;
	float4 vPosLight = mul(WorldPos, ViewProjLight);
	float2 ShadowTexC = Half * vPosLight.xy / vPosLight.w + Half.xx;
	float4 samplePos = calcShadowPos(WorldPos, ShadowTexC, vPosLight);
	if(samplePos.x < 0 || samplePos.y < 0 || samplePos.x > 1 || samplePos.x > 1) return 1;
	return tex2Dlod( TexShadow, samplePos ).x;
}
*/
float4 ps_main(in VS_OUTPUT In) : COLOR
{
	float4 Color;
	Color = tex2D( Tex0, In.TexCoord );
	//return Color;
	
	if(Color.a < 0.5)
	{
		clip(-1);
		return 0;
	}
	else if (Color.a < 1)
	{
		float d = dot(abs(ddx(In.WorldPos.xyz)) + abs(ddy(In.WorldPos.xyz)), float3(1,1,1));
		clip(randomn((floor(In.VertPVDepth.xyz*50)/50).xyzx) - 1 /*+ (Color.a - 0.5) * 2*/ + Color.a + max(0, d*5 - 1));
		Color.a = 1;
	}

	float a = tex2Dlod( Tex0, float4(In.TexCoord+float2(32/4096.0,32/4096.0), 0, 6) ).a;
	if(a < 0.999)
	{
		Color.rgb *= saturate(In.Diffuse.rgb * (1 + dot(normalize(In.WorldPos.xyz), -Sun.vWorldDir) / 3) * Sun.vDiffuse + vAmbientLight);
	}
	else
	{
		float3 N = normalize(cross(ddx(In.WorldPos.xyz), ddy(In.WorldPos.xyz)));
		float NdotL = saturate(dot(N, Sun.vWorldDir));
		Color.rgb *= saturate(NdotL * Sun.vDiffuse + vAmbientLight);
		if(NdotL > 0)
		{
			float3 H = normalize(Sun.vWorldDir - normalize(In.WorldPos.xyz));
			Color.rgb += pow(saturate(dot(H,N)), 10) * 0.15 * Sun.vSpecular;
		}
	}
	ApplyFog(Color, CalcFog(In.VertPVDepth.w));
	return Color;
}

technique Scenery
{
	pass Pass1
	{
		VertexShader = compile vs_3_0 vs_main();
		PixelShader = compile ps_3_0 ps_main();
	}
}